#ifndef DBASEWND_H
    #define DBASEWND_H

    #include "DObjeto.h"
    #include "DMensajesWnd.h"
    #include "DBaseWnd_Estilos.h"

    #include <commctrl.h>

    #pragma comment(lib, "UxTheme.lib")		// Libreria para los temas extendidos de windows (a partir de windows XP)
    #include <Uxtheme.h>

    #ifndef GET_X_LPARAM
        //! Macro para obtener la coordenada X de un LPARAM
	    #define GET_X_LPARAM(lp)			((int)(short)LOWORD(lp))
    #endif

    #ifndef GET_Y_LPARAM
        //! Macro para obtener la coordenada Y de un LPARAM 
	    #define GET_Y_LPARAM(lp)			((int)(short)HIWORD(lp))
    #endif

    //! Espacio de nombres DWL
    namespace DWL {

        // Tipos de clase BaseWnd
        enum DEnum_TipoBaseWnd {
            DEnum_TipoBaseWnd_Indefinido,
            // Ventanas / Dialogos
            DEnum_TipoBaseWnd_Ventana,
            DEnum_TipoBaseWnd_Dialogo,
            DEnum_TipoBaseWnd_DialogoModal,
            // Controles de windows
            DEnum_TipoBaseWnd_Button,
            DEnum_TipoBaseWnd_ComboBox,
            DEnum_TipoBaseWnd_EditBox,
            DEnum_TipoBaseWnd_ListView,
            DEnum_TipoBaseWnd_TreeView,
            DEnum_TipoBaseWnd_TreeViewDirectorios
        };


        //! Clase super base para cualquier ventana y control
        class DBaseWnd : public DObjeto { 
          public: //////////////////////////////////// Miembros publicos

                                                    //! Constructor.
		                                            /*! Constructor.
				                                            \fn			DBaseWnd(void);
				                                            \return		No devuelve nada.
		                                            */
                                                    DBaseWnd(void) : _hWnd(0) { };

												    //! Funcin para mostrar / ocultar la ventana / control.
												    /*! Esta funcin muestra / oculta la ventana / control.
														    \fn			virtual void Visible(const bool nMostrar);
														    \param[in]	nMostrar : True para mostrar la ventana / control, false para ocultarlo.
														    \return		No devuelve nada.
												    */
		     virtual void					        Visible(const bool nMostrar);

												    //! Funcin que retorna si la ventana / control es visible.
												    /*!	Esta funcion devuelve si la ventana / control es visible.
														    \fn			const bool Visible(void);
														    \return		Devuelve TRUE si la ventana / control es visible, FALSE en caso contrario.
												    */
		     const bool				        	    Visible(void);

												    //! Funcin para activar / desactivar la ventana / control.
												    /*!	Esta funcin activa / desactiva la ventana / control.
														    \fn			void Activado(const bool nActivar);
														    \param[in]	nActivar	: Parametro en el que especificaremos si queremos activar o desactivar la ventana / control.
														    \return		No devuelve nada.
												    */
		     virtual void					        Activado(const bool nActivar);

												    //! Funcin que retorna si la ventana / control esta activado.
												    /*!	Esta funcion devuelve si la ventana / control esta activado.
														    \fn			virtual const bool Activado(void);
														    \return		Devuelve TRUE si la ventana / control esta activado, FALSE en caso contrario.
												    */
		     virtual const bool 		            Activado(void);

												    //! Funcin que asigna el foco a esta ventana / control.
												    /*!	Esta funcion asigna el foco a esta ventana / control.
														    \fn			virtual void AsignarFoco(void);
														    \return		No devuelve nada.
												    */
		     virtual void					        AsignarFoco(void);

												    //! Funcin que retorna si esta ventana /control tiene el foco del teclado.
												    /*!	Esta funcion devuelve si esta ventana /control tiene el foco del teclado.
														    \fn			virtual bool Foco(void);
														    \return		Devuelve true si esta ventana tiene el foco del teclado, false en caso contrario.
												    */
		     virtual bool					    	Foco(void);

												    //! Funcin que retorna si esta ventana /control tiene el mouse encima.
												    /*!	Esta funcion devuelve si esta ventana /control tiene el mouse encima.
														    \fn			virtual bool MouseEncima(void);
														    \return		Devuelve true si esta ventana tiene el cursor del raton encima, false en caso contrario.
												    */
             virtual bool                           MouseEncima(void);

												    //! Funcin que asigna una region a esta ventana / control.
												    /*!	Esta funcion asigna una region a esta ventana / control.
														    \fn			virtual int AsignarRegion(HRGN nRegion, const BOOL nRepintar = true);
														    \param[in]	nRegion		: Region que queremos asignar a esta ventana / control.
														    \param[in]	nRepintar	: Valor en el que especificamos si se debe repintar la ventana / control.
														    \return		Devuelve 0 si la funcion ha fallado, cualquier otro numero para advertir que se ha asignado la region correctamente.
												    */
		     virtual int						    AsignarRegion(HRGN nRegion, const BOOL nRepintar = true);

												    //! Funcin que retorna el identificador de ventana HWND.
												    /*!	Esta funcion devuelve el identificador de ventana HWND.
														    \fn			HWND hWnd(void);
														    \return		Devuelve el HWND para esta ventana / control.
												    */
		     HWND							        hWnd(void);

												    //! Funcin para mover la ventana / control a la posicion y el tamao especificados.
												    /*!	Esta funcin mueve la ventana / control a la posicion y tamao especificados.
														    \fn			virtual void Mover(const int cX, const int cY, const int cAncho, const int cAlto, const bool cRepintar = true);
														    \param[in]	cX			: Nueva posicion X para la ventana / control.
														    \param[in]	cY			: Nueva posicion Y para la ventana / control.
														    \param[in]	cAncho		: Nuevo ancho para la ventana / control.
														    \param[in]	cAlto		: Nueva altura para la ventana / control.
														    \param[in]	cRepintar	: True para repintar la ventana / control, false para dejarlo sin repintar.
														    \return		No devuelve nada.
												    */
		     virtual void							Mover(const int cX, const int cY, const int cAncho, const int cAlto, const bool cRepintar = false);

												    //! Funcin para crear un temporizador en esta ventana / control.
												    /*!	Esta funcin crea un temporizador en esta ventana / control.
														    \fn			void CrearTemporizador(const UINT nID, const UINT nMiliSegundos);
														    \param[in]	nID				: ID para el temporizador.
														    \param[in]	nMiliSegundos	: Tiempo en milisegundos que pasara hasta que salte el temporizador.
														    \return		No devuelve nada.
														    \remarks	Para obtener cuando salta un temporizador debemos usaar la funcion Evento_Temporizador()
												    */
		     void					        		CrearTemporizador(const UINT nID, const UINT nMiliSegundos);

												    //! Funcin para eliminar un temporizador en esta ventana / control.
												    /*!	Esta funcin elimina un temporizador en esta ventana / control.
														    \fn			void EliminarTemporizador(const UINT nID);
														    \param[in]	nID				: ID del temporizador a eliminar.
														    \return		No devuelve nada.
												    */
		     void				        			EliminarTemporizador(const UINT nID);

												    //! Funcin que destruye esta ventana / control.
												    /*!	Esta funcion destruye esta ventana / control.
														    \fn			virtual BOOL Destruir(void);
														    \return		Devuelve TRUE si la operacin se completo, FALSE en caso contrario.
												    */
		     virtual BOOL						    Destruir(void);

												    //! Funcin que asigna la opacidad para la ventana / control.
												    /*!	Esta funcion asigna la opacidad para la ventana / control.
														    \fn			void Opacidad(const BYTE nNivel);
														    \param[in]	nNivel : Nivel de opacidad (0-255)
														    \return		No devuelve nada.
														    \remarks	Funcin no soportada en VC6.
												    */
		     void	        						Opacidad(const BYTE nNivel);

												    //! Funcin que retorna la ID esta ventana / control.
												    /*!	Esta funcion devuelve la ID de esta ventana / control.
														    \fn			const int ID(void);
														    \return		Devuelve la ID de esta ventana / control.
												    */
		     virtual UINT					        ID(void);

                                                    //! Funcin que retorna los estilos de esta ventana / control
                                                    /*  Esta funcin retorna una clase DBaseWnd_Estilos que contiene funciones para determinar que estilos estan activados o no.
                                                            \fn         void ObtenerEstilos(DBaseWnd_Estilos &nEstilos);
                                                            \param[out] nEstilos : Clase DBaseWnd_Estilos en la que se depositaran los estilos de esta ventana / control.
                                                            \return     Esta funcin no devuelve nada.
                                                    */
             void                                   ObtenerEstilos(DBaseWnd_Estilos &nEstilos);

                                                    //! Funcin para asignar los estilos de esta ventana / control
                                                    /*  Esta funcin permite asignar uno o mas estilos mediante el parametro nEstilos previamente preparado
                                                            \fn         void AsignarEstilos(DBaseWnd_Estilos &nEstilos)
                                                            \param[in]  nEstilos : Clase DBaseWnd_Estilos que contiene los nuevos estilos a asignar.
                                                            \return     No devuelve nada.
                                                            \remarks    Esta funcin esta pensada para modificar todos los estilos de golpe, por lo que si quieres modificar un solo estilo conservando los valores de los demas,
                                                                        primero deberas obtener los estilos mediante la funcin DBaseWnd_Estilos Estilos(void), para luego modificar lo que te interese, y finalmente pasar la
                                                                        clase DBaseWnd_Estilos a esta funcin.
                                                    */
             void                                   AsignarEstilos(DBaseWnd_Estilos &nEstilos);

                                                    //! Funcin que retorna los estilos extendidos de esta ventana / control
                                                    /*  Esta funcin retorna una clase DBaseWnd_EstilosEx que contiene funciones para determinar que estilos extendidos estan activados o no.
                                                            \fn         void ObtenerEstilosEx(DBaseWnd_EstilosEx &nEstilos);
                                                            \param[out] nEstilos : Clase DBaseWnd_EstilosEx en la que se depositaran los estilos de esta ventana / control.
                                                            \return     No devuelve nada.
                                                    */
             void                                   ObtenerEstilosEx(DBaseWnd_EstilosEx &nEstilos);

                                                    //! Funcin para asignar los estilos extendidos de esta ventana / control
                                                    /*  Esta funcin permite asignar uno o mas estilos extendidos mediante el parametro nEstilos previamente preparado
                                                            \fn         void AsignarEstilosEx(DBaseWnd_EstilosEx &nEstilosEx)
                                                            \param[in]  nEstilosEx : Clase DBaseWnd_EstilosEx que contiene los nuevos estilos a asignar.
                                                            \return     No devuelve nada.
                                                            \remarks    Esta funcion esta pensada para modificar todos los estilos extendidos de golpe, por lo que si quieres modificar un solo estilo conservando los valores de los demas,
                                                                        primero deberas obtener los estilos mediante la funcin DBaseWnd_EstilosEx EstilosEx(void), para luego modificar lo que te interese, y finalmente pasar la
                                                                        clase DBaseWnd_EstilosEx a esta funcin.
                                                    */
             void                                   AsignarEstilosEx(DBaseWnd_EstilosEx &nEstilosEx);


             virtual const DEnum_TipoBaseWnd        TipoBaseWnd(void)   { return DEnum_TipoBaseWnd_Indefinido; };

             virtual const TCHAR                   *Objeto_Nombre(void) { return TEXT("DBaseWnd"); };
             virtual const DEnum_Objeto             Objeto_ID(void)     { return DEnum_Objeto_BaseWnd; };

		    protected : ////////////////////////////// Miembros protegidos

             void                                  _AgregarAppBaseWnd(const UINT nID, DBaseWnd *nPadre);

		                                            //! Funcin que registra la clase ventana.
		                                            /*!	Esta funcion registra la clase ventana.
				                                            \fn			ATOM _RegistrarClase(const TCHAR *nNombre, HBRUSH nColorFondo, const int nIconoRecursos, WNDPROC WindowProcedureInicial);
				                                            \param[in]	nNombre					: Nombre para la clase ventana.
                                                            \param[in]  WindowProcedureInicial	: WindowProcedure estatico que enlazara con el GestorMensajes virtual
				                                            \param[in]	nIconoRecursos			: ID del icono de los recursos que se asignara a la ventana. Puede ser 32512 para que se asigne el icono de la aplicacin.
				                                            \param[in]	nColorFondo				: Brocha con el color del fondo de la ventana. Puede ser NULL.
				                                            \return		Devuelve el ATOM creado con RegisterClassEx, NULL en caso de error.
		                                            */
             ATOM                                  _RegistrarClase(const TCHAR *nNombre, WNDPROC WindowProcedureInicial, const int nIconoRecursos = 0, HBRUSH nColorFondo = 0);

												    //! Identificador para la ventana / control.
		     HWND				                   _hWnd;
        };
        //////////////////////////////////////////////
    };

#endif